"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const fs = require("fs-extra");
const got = require("got");
const path = require("path");
class GotDownloader {
    /**
     * @param options - see [`got#options`](https://github.com/sindresorhus/got#options) for possible keys/values.
     */
    async download(url, targetFilePath, options) {
        await fs.mkdirp(path.dirname(targetFilePath));
        const writeStream = fs.createWriteStream(targetFilePath);
        await new Promise((resolve, reject) => {
            const downloadStream = got.stream(url, options);
            downloadStream.pipe(writeStream);
            downloadStream.on('error', error => {
                if (error.name === 'HTTPError' && error.statusCode === 404) {
                    error.message += ` for ${error.url}`;
                }
                if (writeStream.destroy) {
                    writeStream.destroy(error);
                }
                reject(error);
            });
            writeStream.on('error', error => reject(error));
            writeStream.on('close', () => resolve());
        });
    }
}
exports.GotDownloader = GotDownloader;
//# sourceMappingURL=GotDownloader.js.map